"""
Copyright (C) 2021-2025 NICE s.r.l.
All Rights Reserved

This software is the confidential and proprietary information
of NICE s.r.l. ("Confidential Information").
You shall not disclose such Confidential Information
and shall use it only in accordance with the terms of
the license agreement you entered into with NICE.


Configuration parameters

A configuration parameter consists of:
- section name
- parameter name
- environment variable name
The section name and parameter name are read from the configuration file, the environment variable name is read
from the os environment variable

class:

ConfigurationParameter -- responsible for defining a list of enumerations related to
                     the configuration parameters used by the CLI

    methods:

    __init__(conf_section_name, conf_param_name, env_var_name, to_value, cli_option_name):
        Create the enumerations.
"""

from enum import Enum
from typing import Callable
from dcvsmcli.conf.validation import validate, to_boolean_value, to_output_format_value, to_string_value, to_uri_value


class ConfigurationParameter(Enum):
    BROKER_URL = ("broker", "url", None, validate("url", to_uri_value), "url")
    OUTPUT_FORMAT = ("output", "output-format", None, to_output_format_value, "output_format")
    DEBUG = ("output", "debug", None, validate("debug", to_boolean_value), "debug")
    NO_VERIFY_SSL = ("security", "no-verify-ssl", None, validate("no-verify-ssl", to_boolean_value), "no_verify_ssl")
    CA_BUNDLE = ("security", "ca-bundle", None, to_string_value, "ca_bundle")
    AUTH_SERVER = ("authentication", "auth-server-url", "DCV_SM_AUTH_SERVER_URL", validate("auth-server-url", to_uri_value), "auth_server")
    CLIENT_ID = ("authentication", "client-id", "DCV_SM_CLIENT_ID", to_string_value, None)
    CLIENT_PASSWORD = ("authentication", "client-password", "DCV_SM_CLIENT_PASSWORD", to_string_value, None)
    OAUTH2_TOKEN = (None, "oauth2_token", "DCV_SM_OAUTH2_TOKEN", to_string_value, None)

    def __init__(self, conf_section_name: str, conf_param_name: str, env_var_name: str, to_value: Callable, cli_option_name: str):
        """
        :param conf_section_name: str
        :param conf_param_name: str
        :param env_var_name: str
        :param to_value: Callable
        :param cli_option_name: str
        """

        self.conf_section_name = conf_section_name
        self.conf_param_name = conf_param_name
        self.env_var_name = env_var_name
        self.to_value = to_value
        self.cli_option_name = cli_option_name
