"""
Copyright (C) 2013-2025 NICE s.r.l.
All Rights Reserved

This software is the confidential and proprietary information
of NICE s.r.l. ("Confidential Information").
You shall not disclose such Confidential Information
and shall use it only in accordance with the terms of
the license agreement you entered into with NICE.


JSON Utils

class:

    CustomJsonEncoder -- customize the date time format of the object returned by the response and remove all the fields
                        with None values

    methods:

    def remove_none_fields(api_response: dict) -> dict:
        Recursively remove all None values from the response


methods:

def print_json(api_response: any):
    Pretty print the json of the response with date time well formatted
"""

import datetime
import json
from typing import Any


class CustomJsonEncoder(json.JSONEncoder):
    def default(self, o):
        if isinstance(o, datetime.datetime):
            return o.isoformat()

        return self.remove_none_fields(o.to_dict())

    def remove_none_fields(self, api_response: dict) -> dict:
        """
        :param api_response: dict
        :return: dict
        """
        if isinstance(api_response, list):
            return [self.remove_none_fields(x) for x in api_response if x is not None]
        elif isinstance(api_response, dict):
            return {key: self.remove_none_fields(val) for key, val in api_response.items() if val is not None}
        else:
            return api_response


def print_json(api_response: Any):
    """
    :param api_response: Any
    """
    print(json.dumps(api_response, indent=4, cls=CustomJsonEncoder))
