"""
Copyright (C) 2013-2025 NICE s.r.l.
All Rights Reserved

This software is the confidential and proprietary information
of NICE s.r.l. ("Confidential Information").
You shall not disclose such Confidential Information
and shall use it only in accordance with the terms of
the license agreement you entered into with NICE.


CLI Return Codes

class:

CliReturnCodes -- responsible for getting the return codes of the CLI
"""


#
# This class needs to be Python 2.x compliant
# since it is used during Python version check
#
class CliReturnCodes:
    """Return codes class of the CLI"""

    # Command was successful
    SUCCESSFUL = 0

    # The configuration file passed to the CLI was not found or may be corrupt.
    CONFIG_FILE_ERROR = 1

    # Missing any required subcommands or arguments or using any unknown commands or arguments
    INVALID_COMMAND_ARGUMENT = 2

    # The process received a SIGINT (Ctrl-C).
    SIGINT_SIGNAL = 130

    # Command syntax was invalid, an unknown parameter was provided, or a parameter value was incorrect
    COMMAND_SYNTAX_INVALID = 252

    # The system environment or configuration was invalid. Missing configuration or credentials
    INVALID_CONFIGURATION = 253

    # The service returned an error. Incorrect API usage or other service specific issues
    SERVICE_ERROR = 254

    # General catch-all error. An unspecified runtime error occurred when running the command.
    GENERAL_ERROR = 255
